set more off
pause off
graph set window fontface "Times New Roman"
cap log close
log using "${mainpath}/Log/DoubleHet/DoubleHet_Credit_Size_${response}.log", replace

set level 90
set more off

global HORIZON  = 20 
by gvkeyn : gen firmlife = _N
global LAGS =  4 

cap drop f*
cap drop lag*
 
if "$response" == "invratio" {
global rscalelabelmainx "yscale(r(-2 1)) ylabel(-2(1)1, labsize(large))" 
drop if cyear < 1986 
}

if "$response" == "lnRealSales" {
global rscalelabelmainx "yscale(r(-10 5)) ylabel(-10(2)4, labsize(large))" 
}

if "$response" == "lnempC" {
global rscalelabelmainx "yscale(r(-4 2)) ylabel(-4(2)2, labsize(large))" 
}

if "$response" == "logppentq" {
global rscalelabelmainx "yscale(r(-6 2)) ylabel(-6(2)2, labsize(large))" 
}

foreach y in $response {

	forvalues h=0/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
		
	}

}

foreach y in $instrument {

	forvalues h=18/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
		
	}
}


foreach y in $policy_variable {
		
	forvalues h=0/${HORIZON} {
		
		qui: gen f`h'`y' = F`h'.`y' - L.`y'
		
	}	
}


foreach y in $controls {	
		

	forvalues i=1/${LAGS} {
		
		qui: gen lag`i'`y' = L`i'.`y'
		global lagsAll ${lagsAll} lag`i'`y'
				
	}
}

sort gvkeyn qdate
cap drop horizon
gen horizon = _n - 1 if _n<= $HORIZON + 1

cap drop samp2
reg f${HORIZON}${instrument} ${instrument}
gen samp2 = e(sample)

*
foreach y in $response {

foreach h in 0 4 8 10 12 16   {  

 ivreghdfe f`h'`y' c.Trend#ibn.cate_var  ( c.${npolicy_variable}#ibn.cate_var c.${ppolicy_variable}#ibn.cate_var  = ///																	
						  c.${ninstrument}#ibn.cate_var       c.${pinstrument}#ibn.cate_var) ///																		
if samp == 1 , cluster(qdate gvkeyn) absorb(gvkeyn#ibn.cate_var) bw(16)


ereturn display 

matrix rtable`h'=r(table)
matrix list rtable`h'

}
}

* for testing, use horizon 10 estimates
foreach y in $response {

foreach h in 10  {   

 ivreghdfe f`h'`y' c.Trend#ibn.cate_var  ( c.${npolicy_variable}#ibn.cate_var c.${ppolicy_variable}#ibn.cate_var  = ///																	
						  c.${ninstrument}#ibn.cate_var       c.${pinstrument}#ibn.cate_var) ///																		
if samp == 1 , cluster(qdate gvkeyn) absorb(gvkeyn#ibn.cate_var) bw(16)

}
}

lincom _b[1.cate_var#${ppolicy_variable}] - _b[3.cate_var#${ppolicy_variable}]
lincom _b[2.cate_var#${ppolicy_variable}] - _b[4.cate_var#${ppolicy_variable}]
lincom _b[1.cate_var#${ppolicy_variable}] - _b[2.cate_var#${ppolicy_variable}] 
lincom _b[3.cate_var#${ppolicy_variable}] - _b[4.cate_var#${ppolicy_variable}]


lincom _b[1.cate_var#${npolicy_variable}] - _b[3.cate_var#${npolicy_variable}]
lincom _b[2.cate_var#${npolicy_variable}] - _b[4.cate_var#${npolicy_variable}]
lincom _b[1.cate_var#${npolicy_variable}] - _b[2.cate_var#${npolicy_variable}]
lincom _b[3.cate_var#${npolicy_variable}] - _b[4.cate_var#${npolicy_variable}]


capture program drop make_stars
program define       make_stars, rclass
if `1' > .1 {
return local star ""
}
if `1' > .05  & `1' <= .1 {
return local star "*"
}
if `1' > .01  & `1' <= .05 {
return local star "**"
}
if `1' < .01 {
return local star "***"
}
end

foreach y in $response {


foreach h in  0 4 8 10 12 16 { //6   

local       h`h'_b_n_cat1  = string(rtable`h'[1,1], "%6.2f" )
local       h`h'_low_n_cat1 = string(rtable`h'[5,1], "%6.2f" )
local       h`h'_up_n_cat1 = string(rtable`h'[6,1], "%6.2f" )

local       h`h'_p_n_1=  rtable`h'[4,1] 
make_stars `h`h'_p_n_1'
local       h`h'_s_n_1 `r(star)'

local       h`h'_b_n_cat2  = string(rtable`h'[1,2], "%6.2f" )
local       h`h'_low_n_cat2 = string(rtable`h'[5,2], "%6.2f" )
local       h`h'_up_n_cat2 = string(rtable`h'[6,2], "%6.2f" )

local       h`h'_p_n_2=       rtable`h'[4,2] 
make_stars `h`h'_p_n_2'
local       h`h'_s_n_2 `r(star)'
*/

local       h`h'_b_n_cat3  = string(rtable`h'[1,3], "%6.2f" )
local       h`h'_low_n_cat3 = string(rtable`h'[5,3], "%6.2f" )
local       h`h'_up_n_cat3 = string(rtable`h'[6,3], "%6.2f" )

local       h`h'_p_n_3=       rtable`h'[4,3] 
make_stars `h`h'_p_n_3'
local       h`h'_s_n_3 `r(star)'


local       h`h'_b_n_cat4  = string(rtable`h'[1,4], "%6.2f" )
local       h`h'_low_n_cat4 = string(rtable`h'[5,4], "%6.2f" )
local       h`h'_up_n_cat4 = string(rtable`h'[6,4], "%6.2f" )

local       h`h'_p_n_4=       rtable`h'[4,4] 
make_stars `h`h'_p_n_4'
local       h`h'_s_n_4 `r(star)'


local       h`h'_b_p_cat1  = string(rtable`h'[1,5], "%6.2f" )
local       h`h'_low_p_cat1 = string(rtable`h'[5,5], "%6.2f" )
local       h`h'_up_p_cat1 = string(rtable`h'[6,5], "%6.2f" )

local       h`h'_p_p_1=       rtable`h'[4,5] 
make_stars `h`h'_p_p_1'
local       h`h'_s_p_1 `r(star)'

*
local       h`h'_b_p_cat2  = string(rtable`h'[1,6], "%6.2f" )
local       h`h'_low_p_cat2 = string(rtable`h'[5,6], "%6.2f" )
local       h`h'_up_p_cat2 = string(rtable`h'[6,6], "%6.2f" )

local       h`h'_p_p_2=       rtable`h'[4,6] 
make_stars `h`h'_p_p_2'
local       h`h'_s_p_2 `r(star)'
*

local       h`h'_b_p_cat3  = string(rtable`h'[1,7], "%6.2f" )
local       h`h'_low_p_cat3 = string(rtable`h'[5,7], "%6.2f" )
local       h`h'_up_p_cat3 = string(rtable`h'[6,7], "%6.2f" )

local       h`h'_p_p_3=       rtable`h'[4,7] 
make_stars `h`h'_p_p_3'
local       h`h'_s_p_3 `r(star)'


local       h`h'_b_p_cat4  = string(rtable`h'[1,8], "%6.2f" )
local       h`h'_low_p_cat4 = string(rtable`h'[5,8], "%6.2f" )
local       h`h'_up_p_cat4 = string(rtable`h'[6,8], "%6.2f" )

local       h`h'_p_p_4=       rtable`h'[4,8] 
make_stars `h`h'_p_p_4'
local       h`h'_s_p_4 `r(star)'

}

*** ALL GROUPS 
capture file close file_write
file open          file_write using "${mainpath}/Tables/Het_DoubleCut/IRF_Table_`y'.tex", write replace
file write         file_write ///
"\begin{table}[!htb]"                 	 											   _n ///
"\caption{`y' Response to Asymmetric Effects of Monetary Policy}"                      _n ///
"\label{tab:example}"              													   _n ///
"\centering"                                                                           _n ///
"\footnotesize" 			 														   _n ///
"\begin{adjustbox}{width=0.90\textwidth}" 								 	    	    _n ///
"\begin{threeparttable}"  															   _n ///
"\begin{tabular}{l|lcccccc}" 														   _n ///
"& & $ h_{0}$ & $ h_{4}$ & $ h_{8}$ & $ h_{10}$ & $ h_{12}$ & $ h_{16}$  \\"                 _n ///
"\hline "		   		              					 			                   _n ///
"   High rating - Small   & $\beta^{+}$              &  ""`h0_b_p_cat1'`h0_s_p_1' ""     &  ""`h4_b_p_cat1'`h4_s_p_1'""    &  ""`h8_b_p_cat1'`h8_s_p_1' ""  & ""`h10_b_p_cat1'`h10_s_p_1'""  &  ""`h12_b_p_cat1'`h12_s_p_1'"" &  ""`h16_b_p_cat1'`h16_s_p_1'"" \\"      _n ///
"          &         & (""`h0_low_p_cat1',  `h0_up_p_cat1'     "")  & (""`h4_low_p_cat1' , `h4_up_p_cat1'"") & (""`h8_low_p_cat1' ,  `h8_up_p_cat1'"") & (""`h10_low_p_cat1' ,  `h10_up_p_cat1'"") & (""`h12_low_p_cat1' ,  `h12_up_p_cat1'"") & (""`h16_low_p_cat1' ,  `h16_up_p_cat1'"")  \\" _n ///
"  & $\beta^{-} $    &  "" `h0_b_n_cat1'`h0_s_n_1' ""   &      ""`h4_b_n_cat1'`h4_s_n_1' ""   &      ""`h8_b_n_cat1'`h8_s_n_1'"" &   ""`h10_b_n_cat1'`h10_s_n_1'"" &   ""`h12_b_n_cat1'`h12_s_n_1'"" &   ""`h16_b_n_cat1'`h16_s_n_1'""  \\" _n ///
"         &         & (""`h0_low_n_cat1',  `h0_up_n_cat1'     "")  & (""`h4_low_n_cat1'  ,  `h4_up_n_cat1'"")   & (""`h8_low_n_cat1'  ,  `h8_up_n_cat1'"")  &   (""`h10_low_n_cat1'  ,  `h10_up_n_cat1'"")  & (""`h12_low_n_cat1'  ,  `h12_up_n_cat1'"") & (""`h16_low_n_cat1'  ,  `h16_up_n_cat1'"")    \\" _n ///
"\hline"  _n ///
"   High rating - Large    & $\beta^{+}  $            &  ""`h0_b_p_cat2'`h0_s_p_2' ""     &  ""`h4_b_p_cat2'`h4_s_p_2'""    &  ""`h8_b_p_cat2'`h8_s_p_2' ""  & ""`h10_b_p_cat2'`h10_s_p_2'""  &  ""`h12_b_p_cat2'`h12_s_p_2'"" &  ""`h16_b_p_cat2'`h16_s_p_2'"" \\"      _n ///
"          &         & (""`h0_low_p_cat2',  `h0_up_p_cat2'     "")  & (""`h4_low_p_cat2' , `h4_up_p_cat2'"") & (""`h8_low_p_cat2' ,  `h8_up_p_cat2'"") & (""`h10_low_p_cat2' ,  `h10_up_p_cat2'"") & (""`h12_low_p_cat2' ,  `h12_up_p_cat2'"") & (""`h16_low_p_cat2' ,  `h16_up_p_cat2'"")  \\" _n ///
"  & $\beta^{-} $     &  "" `h0_b_n_cat2'`h0_s_n_2' ""   &      ""`h4_b_n_cat2'`h4_s_n_2' ""   &      ""`h8_b_n_cat2'`h8_s_n_2'"" &   ""`h10_b_n_cat2'`h10_s_n_2'"" &   ""`h12_b_n_cat2'`h12_s_n_2'"" &   ""`h16_b_n_cat2'`h16_s_n_2'""  \\" _n ///
"         &         & (""`h0_low_n_cat2',  `h0_up_n_cat2'     "")  & (""`h4_low_n_cat2'  ,  `h4_up_n_cat2'"")   & (""`h8_low_n_cat2'  ,  `h8_up_n_cat2'"")  &   (""`h10_low_n_cat2'  ,  `h10_up_n_cat2'"")  & (""`h12_low_n_cat2'  ,  `h12_up_n_cat2'"") & (""`h16_low_n_cat2'  ,  `h16_up_n_cat2'"")    \\" _n ///
"\hline"  _n ///
"  Low rating - Small & $\beta^{+}$          &  ""`h0_b_p_cat3'`h0_s_p_3' ""                  &  ""`h4_b_p_cat3'`h4_s_p_3' ""   &  ""`h8_b_p_cat3'`h8_s_p_3'""    & ""`h10_b_p_cat3'`h10_s_p_3'""    &  ""`h12_b_p_cat3'`h12_s_p_3'"" &  ""`h16_b_p_cat3'`h16_s_p_3'""   \\" _n ///
"          &         & (""`h0_low_p_cat3',  `h0_up_p_cat3'     "")  & (""`h4_low_p_cat3' ,  `h4_up_p_cat3'"")  & (""`h8_low_p_cat3' ,  `h8_up_p_cat3'"") & (""`h10_low_p_cat3' ,  `h10_up_p_cat3'"")  & (""`h12_low_p_cat3' ,  `h12_up_p_cat3'"") & (""`h16_low_p_cat3' ,  `h16_up_p_cat3'"")  \\" _n ///
" & $\beta^{-}  $    &  "" `h0_b_n_cat3'`h0_s_n_3' ""   &  ""`h4_b_n_cat3'`h4_s_n_3'"" &  ""`h8_b_n_cat3'`h8_s_n_3'""  &  ""`h10_b_n_cat3'`h10_s_n_3'""  &  ""`h12_b_n_cat3'`h12_s_n_3'"" & ""`h16_b_n_cat3'`h16_s_n_3'""   \\" _n ///
"         &         & (""`h0_low_n_cat3',  `h0_up_n_cat3'     "")  & (""`h4_low_n_cat3'  ,  `h4_up_n_cat3'"")  & (""`h8_low_n_cat3'  ,  `h8_up_n_cat3'"") & (""`h10_low_n_cat3'  ,  `h10_up_n_cat3'"") &  (""`h12_low_n_cat3'  ,  `h12_up_n_cat3'"")   &  (""`h16_low_n_cat3'  ,  `h16_up_n_cat3'"")  \\" _n ///
"\hline"  _n ///
" Low rating - Large & $\beta^{+}  $        &  ""`h0_b_p_cat4'`h0_s_p_4' ""                  &  ""`h4_b_p_cat4'`h4_s_p_4' ""   &  ""`h8_b_p_cat4'`h8_s_p_4'""    & ""`h10_b_p_cat4'`h10_s_p_4'""    &  ""`h12_b_p_cat4'`h12_s_p_4'"" &  ""`h16_b_p_cat4'`h16_s_p_4'""   \\" _n ///
"          &         & (""`h0_low_p_cat4',  `h0_up_p_cat4'     "")  & (""`h4_low_p_cat4' ,  `h4_up_p_cat4'"")  & (""`h8_low_p_cat4' ,  `h8_up_p_cat4'"") & (""`h10_low_p_cat4' ,  `h10_up_p_cat4'"")  & (""`h12_low_p_cat4' ,  `h12_up_p_cat4'"") & (""`h16_low_p_cat4' ,  `h16_up_p_cat4'"")  \\" _n ///
" & $\beta^{-}$      &  "" `h0_b_n_cat4'`h0_s_n_4' ""   &  ""`h4_b_n_cat4'`h4_s_n_4'"" &  ""`h8_b_n_cat4'`h8_s_n_4'""  &  ""`h10_b_n_cat4'`h10_s_n_4'""  &  ""`h12_b_n_cat4'`h12_s_n_4'"" & ""`h16_b_n_cat4'`h16_s_n_4'""   \\" _n ///
"         &         & (""`h0_low_n_cat4',  `h0_up_n_cat4'     "")  & (""`h4_low_n_cat4'  ,  `h4_up_n_cat4'"")  & (""`h8_low_n_cat4'  ,  `h8_up_n_cat4'"") & (""`h10_low_n_cat4'  ,  `h10_up_n_cat4'"") &  (""`h12_low_n_cat4'  ,  `h12_up_n_cat4'"")   &  (""`h16_low_n_cat4'  ,  `h16_up_n_cat4'"")  \\" _n ///
"\hline \hline"				              					 			               _n ///
"\end{tabular}" 															         _n ///																	
"\end{threeparttable}" 																   _n ///
"\end{adjustbox}" 															    	   _n ///
"\end{table}"																													
file close file_write

}

cap log close
